package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.excel.cellseeker.ConstantValueCellSeeker;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConstantValueCellSeekerFactoryBean extends AbstractCellSeekerFactoryBean {

	private String value;

	@Override
	public Object getObject() throws Exception {
		ConstantValueCellSeeker seeker = new ConstantValueCellSeeker();
		seeker.setValue(getValue());

		return seeker;
	}

	@Override
	public Class<ConstantValueCellSeekerFactoryBean> getObjectType() {
		return ConstantValueCellSeekerFactoryBean.class;
	}

	@Override
	BeanDefinitionBuilder parse(Element element,
			CellSeekerFactoryBeanAcceptableXMLParser parser,
			ParserContext parserContext) {
		return parser.parse(element, this, parserContext);
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}
}
